using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carrie Van Stedum</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>3/20/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Blood units can be cross-matched for multiple patients and this data 
	///	access component gets the details associated with those patients.
	///</summary>

		#endregion


	public class PatientAssignments
	{
		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/20/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2593"> 
		///		<ExpectedInput>Array of Patient GUIDS</ExpectedInput>
		///		<ExpectedOutput>DataTable of cross-matched patient details</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2594"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// A blood unit can be cross-matched for multiple patients.
		/// This method returns all cross-matched patients' details.
		/// </summary>
		public static System.Data.DataTable GetPatientsAssignmentDetails(System.Guid bloodUnitGuid)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetBloodUnitAssignedPatients.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetBloodUnitAssignedPatients.divisioncode, System.Data.SqlDbType.Char)
			};
		
			prms[0].Value = bloodUnitGuid;
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;

			return StoredProcedure.GetData(STOREDPROC.GetBloodUnitAssignedPatients.StoredProcName, prms).Tables[0];
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/18/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1218"> 
		///		<ExpectedInput>BloodUnitGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable of cross-matched patient specimen details</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1219"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// A blood unit can be cross-matched for multiple patients.
		/// This method returns all cross-matched patients and specimens.
		/// </summary>
		/// <param name="bloodUnitGuid">Blood Unit unique identifier</param>
		/// <returns>Data table with patient and specimen unique identifiers</returns>
		public static System.Data.DataTable GetPatientSpecimenAssignmentDetails(System.Guid bloodUnitGuid)
		{
			SqlParameter[] prms =	
			{
				new SqlParameter(STOREDPROC.GetBloodUnitAssignedPatientSpecimens.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier)
			};
		
			prms[0].Value = bloodUnitGuid;

			return StoredProcedure.GetData(STOREDPROC.GetBloodUnitAssignedPatientSpecimens.StoredProcName, prms).Tables[0];
		}

	}
}
